#pragma rtGlobals=1		// Use modern global access method.

Function InitDetector()
	If (!DataFolderExists("root:DetectorParam:"))
		Execute("InitDetectorFolder(\"DetectorParam\")")
	Endif
End

Proc InitDetectorFolder(Name)
	String Name
	String OriginalFolder
	
	Silent 1;
	OriginalFolder=GetDataFolder(1)
	NewDataFolder/O/S $Name
	Variable/G ds16_1,ds16_2,ds16_3,ds16_4,ds16_5,ds16_6,ds16_7,ds16_8
	Variable/G ds16_12,ds16_34,ds16_56,ds16_78
	Variable/G ds16_1234, ds16_5678	
	SetDataFolder OriginalFolder
End


Function ButtonDetector(ctrlName) : ButtonControl
	String ctrlName
	String PathFolder="root:DetectorParam:"
	NVAR ds16_1=$PathFolder+"ds16_1"
	NVAR ds16_2=$PathFolder+"ds16_2"	
	NVAR ds16_3=$PathFolder+"ds16_3"
	NVAR ds16_4=$PathFolder+"ds16_4"
	NVAR ds16_5=$PathFolder+"ds16_5"	
	NVAR ds16_6=$PathFolder+"ds16_6"	
	NVAR ds16_7=$PathFolder+"ds16_7"	
	NVAR ds16_8=$PathFolder+"ds16_8"	
	NVAR ds16_12=$PathFolder+"ds16_12"	
	NVAR ds16_34=$PathFolder+"ds16_34"	
	NVAR ds16_56=$PathFolder+"ds16_56"	
	NVAR ds16_78=$PathFolder+"ds16_78"
	NVAR ds16_1234=$PathFolder+"ds16_1234"	
	NVAR ds16_5678=$PathFolder+"ds16_5678"
			
	ds16_1=sum(tous_XY,0,15)
	ds16_2=sum(tous_XY,16,31)
	ds16_3=sum(tous_XY,32,47)
	ds16_4=sum(tous_XY,48,63)
	ds16_5=sum(tous_XY,64,79)
	ds16_6=sum(tous_XY,80,95)
	ds16_7=sum(tous_XY,96,111)
	ds16_8=sum(tous_XY,112,127)
	ds16_12=ds16_1+ds16_2
	ds16_34=ds16_3+ds16_4
	ds16_56=ds16_5+ds16_6
	ds16_78=ds16_7+ds16_8
	ds16_1234=ds16_12+ds16_34
	ds16_5678=ds16_56+ds16_78
End

Window Detector() : graph
	PauseUpdate; Silent 1		// building window...
	 InitDetector()
	Display /W=(304,129,907,487) tous_XY as "Detector"
	ModifyGraph mode=4
	ModifyGraph marker=8
	ModifyGraph mrkThick=0.01
	ModifyGraph lowTrip(left)=1
	ModifyGraph axisEnab(left)={0.14,0.8}
	Cursor/P A tous_XY 3;Cursor/P B tous_XY 18
	ShowInfo
	ValDisplay ds16_1,pos={45,268},size={60,14},limits={0,0,0},barmisc={0,1000}
	ValDisplay ds16_1,value= #" root:DetectorParam:ds16_1"
	ValDisplay ds16_2,pos={113,268},size={60,14},limits={0,0,0},barmisc={0,1000}
	ValDisplay ds16_2,value= #"  root:DetectorParam:ds16_2"
	ValDisplay ds16_3,pos={180,268},size={60,14},limits={0,0,0},barmisc={0,1000}
	ValDisplay ds16_3,value= #"  root:DetectorParam:ds16_3"
	ValDisplay ds16_4,pos={248,268},size={60,14},limits={0,0,0},barmisc={0,1000}
	ValDisplay ds16_4,value= #"  root:DetectorParam:ds16_4"
	ValDisplay ds16_5,pos={316,268},size={60,14},limits={0,0,0},barmisc={0,1000}
	ValDisplay ds16_5,value= #"  root:DetectorParam:ds16_5"
	ValDisplay ds16_6,pos={383,268},size={60,14},limits={0,0,0},barmisc={0,1000}
	ValDisplay ds16_6,value= #"  root:DetectorParam:ds16_6"
	ValDisplay ds16_7,pos={451,268},size={60,14},limits={0,0,0},barmisc={0,1000}
	ValDisplay ds16_7,value= #"  root:DetectorParam:ds16_7"
	ValDisplay ds16_8,pos={520,268},size={60,14},limits={0,0,0},barmisc={0,1000}
	ValDisplay ds16_8,value= #"  root:DetectorParam:ds16_8"
	Button refresh,pos={282,9},size={60,20},proc=ButtonDetector,title="Refresh"
	ValDisplay ds16_12,pos={50,46},size={120,14},title="H 1-32 :",frame=0
	ValDisplay ds16_12,limits={0,0,0},barmisc={0,1000}
	ValDisplay ds16_12,value= #" root:DetectorParam:ds16_12"
	ValDisplay ds16_34,pos={184,46},size={120,14},title="V 1-32 : "
	ValDisplay ds16_34,limits={0,0,0},barmisc={0,1000}
	ValDisplay ds16_34,value= #" root:DetectorParam:ds16_34"
	ValDisplay ds16_56,pos={320,46},size={120,14},title="V 1-32 :"
	ValDisplay ds16_56,limits={0,0,0},barmisc={0,1000}
	ValDisplay ds16_56,value= #" root:DetectorParam:ds16_56"
	ValDisplay ds16_78,pos={456,46},size={120,14},title="H 1-32 :"
	ValDisplay ds16_78,limits={0,0,0},barmisc={0,1000}
	ValDisplay ds16_78,value= #" root:DetectorParam:ds16_78"
	ValDisplay ds16_1234,pos={113,12},size={120,14},title="Ions"
	ValDisplay ds16_1234,limits={0,0,0},barmisc={0,1000}
	ValDisplay ds16_1234,value= #" root:DetectorParam:ds16_1234"
	ValDisplay ds16_5678,pos={391,12},size={145,14},title="Electrons"
	ValDisplay ds16_5678,limits={0,0,0},barmisc={0,1000}
	ValDisplay ds16_5678,value= #" root:DetectorParam:ds16_5678"
	SetDrawLayer UserFront
	SetDrawEnv xcoord= bottom,ycoord= prel,linethick= 2
	DrawLine 63.9721189591078,0.100719424460432,63.9721189591078,1
	SetDrawEnv xcoord= bottom,ycoord= prel,dash= 3
	DrawLine 95.8401486988848,0.107913669064748,95.8401486988848,1.01438848920863
	SetDrawEnv xcoord= bottom,ycoord= prel,dash= 3
	DrawLine 31.8680297397769,0.0971223021582734,31.8680297397769,1.01438848920863
	SetDrawEnv xcoord= bottom,ycoord= prel,dash= 2
	DrawLine 80,0.514388489208633,80,1.01438848920863
	SetDrawEnv xcoord= bottom,ycoord= prel,dash= 2
	DrawLine 112,0.514388489208633,112,1.01438848920863
	SetDrawEnv xcoord= bottom,ycoord= prel,dash= 2
	DrawLine 48,0.514388489208633,48,1.01438848920863
	SetDrawEnv xcoord= bottom,ycoord= prel,dash= 2
	DrawLine 16,0.514388489208633,16,1.01438848920863
	SetDrawEnv linethick= 2
	DrawLine 0.0148698884758364,0.179856115107914,1.0092936802974,0.179856115107914
EndMacro

Window TimeOfFlight() : Graph
	PauseUpdate; Silent 1		// building window...
	Display /W=(237,66,686,587) tous_T as "Time Of Flight"
	AppendToGraph/L=Ions_f Hist_t_ions
	AppendToGraph/L=Elec_a tous_T_e
	AppendToGraph/L=Elec_f Hist_t_elec
	ModifyGraph rgb(tous_T_e)=(0,0,0),rgb(Hist_t_elec)=(0,0,0)
	ModifyGraph axOffset(left)=4.5
	ModifyGraph lblPos(left)=46
	ModifyGraph freePos(Ions_f)={108.986376566758,bottom}
	ModifyGraph freePos(Elec_a)={0,bottom}
	ModifyGraph freePos(Elec_f)={0,bottom}
	ModifyGraph axisEnab(left)={0.25,0.47}
	ModifyGraph axisEnab(Ions_f)={0,0.22}
	ModifyGraph axisEnab(Elec_a)={0.75,0.97}
	ModifyGraph axisEnab(Elec_f)={0.5,0.72}
	Cursor/P A tous_T_e 3636;Cursor/P B tous_T_e 3640
	ShowInfo
	TextBox/N=text0/O=90/A=MC/X=-67.05/Y=24.94 "Electrons"
	TextBox/N=text0_1/O=90/A=MC/X=-66.18/Y=-25.64 " Ions "
	TextBox/N=text1/F=0/A=MC/X=46.92/Y=28.64 "all"
	TextBox/N=text1_1/F=0/A=MC/X=45.58/Y=-14.78 "\\K(65535,0,0)all"
	TextBox/N=text2/F=0/A=MC/X=48.48/Y=11.78 "filtred"
	TextBox/N=text2_1/F=0/A=MC/X=43.49/Y=-43.42 "\\K(65535,0,0)filtred"
	SetDrawLayer UserFront
	SetDrawEnv linethick= 2,linepat= 3
	DrawLine -0.266467065868263,0.517321016166282,1.07784431137725,0.517321016166282
EndMacro

Window HitsDistributions() : Graph
	PauseUpdate; Silent 1		// building window...
	Display /W=(38,42,537,349) nHits1_e as "Hits Distributions"
	AppendToGraph/L=l_e2 nHits2_e
	AppendToGraph/L=l_e3 nHits3_e
	AppendToGraph/L=l_i1 nHits1
	AppendToGraph/L=l_i2 nHits2
	AppendToGraph/L=l_i3 nHits3
	ModifyGraph rgb(nHits1_e)=(0,0,0),rgb(nHits3_e)=(0,0,65535),rgb(nHits1)=(0,0,0)
	ModifyGraph rgb(nHits3)=(0,0,65535)
	ModifyGraph noLabel(l_e2)=2,noLabel(l_e3)=2,noLabel(l_i2)=2,noLabel(l_i3)=2
	ModifyGraph axOffset(left)=6.8
	ModifyGraph axThick(l_e2)=0,axThick(l_e3)=0,axThick(l_i2)=0,axThick(l_i3)=0
	ModifyGraph lblPos(left)=46,lblPos(l_e2)=-20,lblPos(l_i1)=44
	ModifyGraph lblLatPos(l_e2)=1,lblLatPos(l_i1)=-4
	ModifyGraph freePos(l_e2)={1.45116279069767,bottom}
	ModifyGraph freePos(l_e3)={1.9046511627907,bottom}
	ModifyGraph freePos(l_i1)={0,bottom}
	ModifyGraph freePos(l_i2)={0,bottom}
	ModifyGraph freePos(l_i3)={0,bottom}
	ModifyGraph axisEnab(left)={0,0.47}
	ModifyGraph axisEnab(l_e2)={0,0.47}
	ModifyGraph axisEnab(l_e3)={0,0.47}
	ModifyGraph axisEnab(l_i1)={0.5,1}
	ModifyGraph axisEnab(l_i2)={0.5,1}
	ModifyGraph axisEnab(l_i3)={0.5,1}
	Cursor/P B nHits2_e 7
	ShowInfo
	TextBox/N=text0/F=0/A=MC/X=40.23/Y=39.13 "\\s(nHits1_e) single\r\\s(nHits2_e) double\r\\s(nHits3_e) triple\r"
	TextBox/N=text1/O=90/A=MC/X=-65.15/Y=26.52 "Ions"
	TextBox/N=text1_1/O=90/A=MC/X=-64.90/Y=-28.26 "Electrons"
EndMacro
